<?php

namespace App\Entities;

use CodeIgniter\Entity\Entity;
use CodeIgniter\I18n\Time;

class BillFine extends Entity
{
    //protected $dates = ['bill_date', 'bill_due_date'];

    public function __construct()
	{
		helper('general');
	}

    public function getBillDueDate(string $format = 'Y-m-d') {

        return format_date($this->mutateDate($this->attributes['bill_due_date'])->format($format));
    }

    public function getPaymentDate(string $format = 'Y-m-d') {

        if( empty($this->attributes['payment_date']) )
            return "-";

        return format_date($this->mutateDate($this->attributes['payment_date'])->format($format));
    }

    public function getBillFineDate(string $format = 'Y-m-d') {

         if( empty($this->attributes['bill_fine_date']) )
            return "-";

        return format_date($this->mutateDate($this->attributes['bill_fine_date'])->format($format));
    }

    public function Days() {

        $payment_date = !empty($this->attributes['payment_date']) ? $this->attributes['payment_date'] : date('Y-m-d H:i:s');
        $payment_date = Time::createFromFormat('Y-m-d H:i:s', $payment_date);
        $bill_due_date = Time::createFromFormat('Y-m-d H:i:s', $this->attributes['bill_due_date']);
        $days = $bill_due_date->diff($payment_date)->format("%a");

        return $days;

    }

    public function getBillTotal()
    {
        return format_money($this->attributes['bill_total']);
    }

    public function getBillFineTotal()
    {
        return format_money($this->attributes['bill_fine_total']);
    }

    public function getPaymentAmount()
    {
        if( empty($this->attributes['payment_amount']) )
            return "RP 0";

        return format_money($this->attributes['payment_amount']);
    }

    public function billFineRemaining() {

        $bill_fine_total = !empty( $this->attributes['bill_fine_total'] ) ?  $this->attributes['bill_fine_total'] : 0;
        $payment_amount = !empty( $this->attributes['payment_amount'] ) ?  $this->attributes['payment_amount'] : 0;

        $remaining = $this->attributes['bill_total'] + $this->attributes['bill_fine_total'] -  $this->attributes['payment_amount'];

        return $remaining;

    }

    public function formatBillFineRemaining() {
        return format_money($this->billFineRemaining());
    }

    


}