<?php

namespace App\Controllers;

class BillElectric extends BaseController
{	
	protected $billElectricm;

	public function __construct()
	{
		$this->billElectricm = new \App\Models\BillElectricM();
	}

	public function index()
	{
		return;
	}

	public function modal_detail()
	{
		$params = [];
		$data['d'] = $this->billElectricm->getDetail($params);

		return view('BillElectric/modal_detail', $data);
	}

	public function owner_checking_ajax()
	{
		
		$start = 0;
		$length = 0;
		$order = '';
		$sort = [];
		$params = [];
		$records = [];
		$sEcho = intval($this->request->getPost('draw'));

		if( $this->request->getPost('start') ) {
			$start = intval($this->request->getPost('start'));
		}

		if ( intval($this->request->getPost('length')) > 0 ) {
			$length = intval($this->request->getPost('length'));
		}

		//$TotalRecords = $this->model->count()->total;
		$TotalRecords = 50;

		$filtered = false;

		$TotalRecordsFiltered = $TotalRecords;

		if( $filtered ) {
			//$TotalRecordsFiltered = $this->model->count($params)->total;
			$TotalRecordsFiltered = 0;
		}

		$records['data'] = [];
		$no = $start;

		$data = $this->billm->getList($params);

		foreach( $data as $d ) {

			$no++;

			$checkbox = '<input type="checkbox" name="bill_id[]" class="checkboxes" value="'.$d->bill_id.'"/>';

			$actions = '<div class="btn-group">
							<button class="btn blue dropdown-toggle" type="button" data-toggle="dropdown">
								Actions <i class="fa fa-angle-down"></i>
							</button>
							<ul class="dropdown-menu" role="menu">
								<li>
									<a href="'.base_url('bill/owner_checking_view/'.$d->bill_id).'">
										<i class="fa fa-search"></i> View 
									</a>
								</li>
								<li>
									<a href="'.base_url('bill/owner_checking_edit/'.$d->bill_id).'">
										<i class="fa fa-edit"></i> Edit 
									</a>
								</li>
								<li>
									<a href="'.base_url('bill/owner_checking_delete/'.$d->bill_id).'">
										<i class="fa fa-remove"></i> Delete 
									</a>
								</li>
								<li class="divider">
								</li>
							</ul>
						</div>';

			$bill_electric_total = $d->bill_electric_total.' <a href="javascript:;" class="btn btn-xs blue open-modal" data-url="'.base_url('billelectric/detail_modal/'.$d->bill_id).'"><i class="fa fa-search"></i></a>';

			$bill_water_total = $d->bill_water_total.' <a href="javascript:;" class="btn btn-xs blue open-modal" data-url="'.base_url('billwater/detail_modal/'.$d->bill_id).'"><i class="fa fa-search"></i></a>';

			$bill_service_total = $d->bill_service_total.' <a href="javascript:;" class="btn btn-xs blue open-modal" data-url="'.base_url('billservice/detail_modal/'.$d->bill_id).'"><i class="fa fa-search"></i></a>';

			$bill_other_total = $d->bill_other_total.' <a href="javascript:;" class="btn btn-xs blue open-modal" data-url="'.base_url('billother/detail_modal/'.$d->bill_id).'"><i class="fa fa-search"></i></a>';

			$records['data'][] = [
				$checkbox,
				$no,
				$d->unit_va,
				$d->occupant_name,
				$d->bill_date,
				$d->bill_due_date,
				$bill_electric_total,
				$bill_water_total,
				$bill_service_total,
				$bill_other_total,
				$d->totalBill(),
				$d->bill_fine_total,
				$d->payment_last_month,
				$d->payment_amount,
				$d->bill_amount,
				$d->status,
				$actions
			];

		}


		$records["draw"] = $sEcho;
		$records["recordsTotal"] = $TotalRecords;
		$records["recordsFiltered"] = $TotalRecordsFiltered;
		
		return json_encode($records);
	}

	public function test_db() {

		$data = $this->billm->getList();

		foreach($data as $d) {
			print_r($d->toArray());
			echo '<br><br>';
		}

		return;
	}

}
