<?php

namespace App\Models;

use CodeIgniter\Model;

class BillM extends Model
{
    protected $table      = 'bills b';
    protected $primaryKey = 'bill_id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'App\Entities\Bill';
    protected $useSoftDeletes = false;

    //protected $allowedFields = ['name', 'email'];

    protected $useTimestamps = true;
    protected $createdField  = 'created';
    protected $updatedField  = 'updated';
    //protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getList($params = []) {

        $data = [
            'bill_id'       => 0,
            'occupant_id'   => 0,
            'occupant_name' => 'John Doe',
            'unit_va'       => '00130080012345',
            'unit_name'     => 'W 33/21',
            'bill_code'     => 'BILL/W3321/0001',
            'bill_date'     =>  '2021-07-01 06:00:00', 
            'bill_due_date' =>  '2021-07-15 00:00:00',
            'bill_amount'   => 2582017, 
            'bill_electric_id'      => 0,
            'bill_electric_total'   => 276526,
            'bill_water_id'         => 0,
            'bill_water_total'      => 270766,
            'bill_service_id'       => 0,
            'bill_service_total'    => 1814725,
            'bill_other_id'         => 0,
            'bill_other_total'      => 220000,
            'status'                => 0,
            'bill_fine_id'          => 0,
            'bill_fine_total'       => 0,
            'payment_amount'        => 0,
            'payment_last_month'    => 330000,
            'bill_last_month'       => 330000,
        ];

        $result = [];

        $length = !empty($params['length']) ? $params['length'] : 10;
        $start = !empty($params['start']) ? $params['start'] : 0;

        for ($x = $start; $x < $length; $x++) {
            $data['bill_id'] = $x+1;
            $data['occupant_id'] = $x+1;
            $r = new \App\Entities\Bill();
            $result[] = $r->fill($data);
        }

        return $result;

        if(!empty($params['where']))
            $this->where($params['where']);

        if( !empty($params['sort']) ) {
            $this->orderBy($params['sort']['column'], $params['sort']['dir']);
        } else {
           $this->orderBy('b.bill_id');
        }

        if(!empty($params['length']))
            $this->limit($params['length'],$params['start']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }
}