<?php

namespace App\Entities;

use CodeIgniter\Entity\Entity;
use CodeIgniter\I18n\Time;

class BillWater extends Entity
{
    //protected $dates = ['bill_date', 'bill_due_date'];

    public function __construct()
	{
		helper('general');
	}

    public function getBillDate(string $format = 'Y-m-d') {

        return format_date($this->mutateDate($this->attributes['bill_date'])->format($format));
    }

    public function getWaterUsageStart()
    {
        return format_point($this->attributes['water_usage_start']);
    }

    public function getWaterUsageEnd()
    {
        return format_point($this->attributes['water_usage_end']);
    }

    public function getWaterUsageAmount()
    {
        return format_point($this->attributes['water_usage_amount']);
    }

    public function getWaterMeterRate()
    {
        return format_money($this->attributes['water_meter_rate']);
    }

    public function getBillWaterAmount()
    {
        return format_money($this->attributes['bill_water_amount']);
    }

    public function getBillWaterFixed()
    {
        return format_money($this->attributes['bill_water_fixed']);
    }

    public function getBillWaterAdmin()
    {
        return format_money($this->attributes['bill_water_admin']);
    }
    public function getBillWaterPpn()
    {
        return format_money($this->attributes['bill_water_ppn']);
    }

    public function getBillWaterTotal()
    {
        return format_money($this->attributes['bill_water_total']);
    }

    public function getStatus() {

        $status = ( $this->attributes['status'] == 0 ) ? '<span class="label label-danger circle">OUTSTANDING</span>' : '<span class="label label-success circle">COMPLETED</span>';

        return $status; 
    }


}