<?php

namespace App\Entities;

use CodeIgniter\Entity\Entity;
use CodeIgniter\I18n\Time;

class BillService extends Entity
{
    //protected $dates = ['bill_date', 'bill_due_date'];

    public function __construct()
	{
		helper('general');
	}

    public function getBillDate(string $format = 'Y-m-d') {

        return format_date($this->mutateDate($this->attributes['bill_date'])->format($format));
    }

    public function getUnitSize()
    {
        return format_point($this->attributes['unit_size']).' m2';
    }

    public function getServiceChargeRate()
    {
        return format_money($this->attributes['service_charge_rate']);
    }

    public function getBillServiceAmount()
    {
        return format_money($this->attributes['bill_service_amount']);
    }

    public function getBillServicePpn()
    {
        return format_money($this->attributes['bill_service_ppn']);
    }

    public function getBillServiceTotal()
    {
        return format_money($this->attributes['bill_service_total']);
    }

    public function getStatus() {

        $status = ( $this->attributes['status'] == 0 ) ? '<span class="label label-danger circle">OUTSTANDING</span>' : '<span class="label label-success circle">COMPLETED</span>';

        return $status; 
    }


}