<?php

namespace App\Entities;

use CodeIgniter\Entity\Entity;
use CodeIgniter\I18n\Time;

class BillElectric extends Entity
{
    //protected $dates = ['bill_date', 'bill_due_date'];

    public function __construct()
	{
		helper('general');
	}

    public function getBillDate(string $format = 'Y-m-d') {

        return format_date($this->mutateDate($this->attributes['bill_date'])->format($format));
    }

    public function getElectricUsageStart()
    {
        return format_point($this->attributes['electric_usage_start']);
    }

    public function getElectricUsageEnd()
    {
        return format_point($this->attributes['electric_usage_end']);
    }

    public function getElectricUsageAmount()
    {
        return format_point($this->attributes['electric_usage_amount']);
    }

    public function getElectricMeterRate()
    {
        return format_money($this->attributes['electric_meter_rate']);
    }

    public function getElectricMeterPower()
    {
        return format_point($this->attributes['electric_meter_power']);
    }

    public function getElectricMeterService()
    {
        return format_money($this->attributes['electric_meter_service']);
    }

    public function getBillElectricAmount()
    {
        return format_money($this->attributes['bill_electric_amount']);
    }

    public function getBillElectricService()
    {
        return format_money($this->attributes['bill_electric_service']);
    }

    public function getBillElectricPju()
    {
    	return format_money($this->attributes['bill_electric_pju']);
    }

    public function getBillElectricAdmin()
    {
        return format_money($this->attributes['bill_electric_admin']);
    }
    public function getBillElectricPpn()
    {
        return format_money($this->attributes['bill_electric_ppn']);
    }

    public function getBillElectricTotal()
    {
        return format_money($this->attributes['bill_electric_total']);
    }

    public function getStatus() {

        $status = ( $this->attributes['status'] == 0 ) ? '<span class="label label-danger circle">OUTSTANDING</span>' : '<span class="label label-success circle">COMPLETED</span>';

        return $status; 
    }


}